/*
 * Decompiled with CFR 0.152.
 */
package com.company_project;

import com.company_project.AuditLogTable;
import com.company_project.MainAccess;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class ViewAuditLogTable {
    public static void viewAuditLogTable(GridPane gridPane, final Stage primaryStage, final int ssn_1) {
        Label headerLabel = new Label("Company Audit Logs");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 4, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        Label instruction = new Label("Click on row to view complete audit log event");
        GridPane.setHalignment(instruction, HPos.LEFT);
        gridPane.add(instruction, 0, 1, 4, 1);
        final TableView<AuditLogTable> table = new TableView<AuditLogTable>();
        TableColumn idNameCol = new TableColumn("ID");
        TableColumn evtypeNameCol = new TableColumn("Event Type");
        TableColumn evnameNameCol = new TableColumn("Event Name");
        TableColumn timeNameCol = new TableColumn("Creation Time");
        TableColumn useridNameCol = new TableColumn("User ID");
        TableColumn usernameNameCol = new TableColumn("User Name");
        TableColumn payloadNameCol = new TableColumn("Payload");
        idNameCol.setCellValueFactory(new PropertyValueFactory("idnumber"));
        evtypeNameCol.setCellValueFactory(new PropertyValueFactory("evtype"));
        evnameNameCol.setCellValueFactory(new PropertyValueFactory("evname"));
        timeNameCol.setCellValueFactory(new PropertyValueFactory("timestamp"));
        useridNameCol.setCellValueFactory(new PropertyValueFactory("userid"));
        usernameNameCol.setCellValueFactory(new PropertyValueFactory("username"));
        payloadNameCol.setCellValueFactory(new PropertyValueFactory("payload"));
        idNameCol.setSortType(TableColumn.SortType.DESCENDING);
        ObservableList<AuditLogTable> list = ViewAuditLogTable.getAuditList();
        table.setItems(list);
        table.getColumns().addAll(idNameCol, evtypeNameCol, evnameNameCol, timeNameCol, useridNameCol, usernameNameCol, payloadNameCol);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        table.setOnMousePressed(new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent event) {
                System.out.println(((AuditLogTable)table.getSelectionModel().getSelectedItem()).getIdnumber());
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                ViewAuditLogTable.viewAuditLog(gridPane_1, primaryStage, ssn_1, Integer.parseInt(((AuditLogTable)table.getSelectionModel().getSelectedItem()).getIdnumber()));
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        StackPane root = new StackPane();
        root.setPadding(new Insets(5.0));
        root.getChildren().add(table);
        gridPane.add(root, 0, 2, 10, 1);
        Label manLabel = new Label("Manager Logged In:\n" + ssn_1);
        GridPane.setHalignment(manLabel, HPos.LEFT);
        gridPane.add(manLabel, 0, 3, 2, 1);
        Button homeButton = new Button("Go Back Home");
        homeButton.setPrefHeight(20.0);
        homeButton.setDefaultButton(true);
        gridPane.add(homeButton, 0, 4, 6, 1);
        GridPane.setHalignment(homeButton, HPos.LEFT);
        GridPane.setMargin(homeButton, new Insets(2.0, 0.0, 2.0, 0.0));
        homeButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.mainPage(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
    }

    private static void viewAuditLog(GridPane gridPane, final Stage primaryStage, final int ssn_1, final int idnumber) {
        Label headerLabel = new Label("Company Audit Log - " + idnumber);
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 5, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        String evtype = "";
        String evname = "";
        String timestamp = "";
        int userid = 0;
        String username = "";
        String payload = "";
        int max = 0;
        int min = 0;
        String sql1 = "SELECT AL_ID_NUMBER AS NUM, AL_EVENT_TYPE AS EVTYPE, AL_EVENT_NAME AS EVNAME, AL_CREATE_TIME AS CRTIME\n, AL_USER_ID AS USERID, AL_USER_NAME AS USERNAME, AL_PAYLOAD AS PAYLOAD\nFROM AL_RECORDS WHERE AL_ID_NUMBER = " + idnumber;
        String sql2 = "SELECT MAX(AL_ID_NUMBER) AS MAX_NUM, MIN(AL_ID_NUMBER) AS MIN_NUM FROM AL_RECORDS";
        try {
            Connection conn = MainAccess.LocalinitialSetup(2);
            Statement st = conn.createStatement();
            ResultSet res = st.executeQuery(sql1);
            while (res.next()) {
                evtype = res.getString("EVTYPE");
                evname = res.getString("EVNAME");
                timestamp = res.getString("CRTIME");
                userid = res.getInt("USERID");
                username = res.getString("USERNAME");
                payload = res.getString("PAYLOAD");
            }
            res.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        try {
            Connection conn2 = MainAccess.LocalinitialSetup(2);
            Statement st2 = conn2.createStatement();
            ResultSet res2 = st2.executeQuery(sql2);
            while (res2.next()) {
                max = res2.getInt("MAX_NUM");
                min = res2.getInt("MIN_NUM");
            }
            res2.close();
            st2.close();
            conn2.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Label idLabel = new Label("ID: ");
        GridPane.setHalignment(idLabel, HPos.LEFT);
        gridPane.add(idLabel, 0, 1, 1, 1);
        Label idvalueLabel = new Label(String.valueOf(idnumber));
        GridPane.setHalignment(idvalueLabel, HPos.LEFT);
        gridPane.add(idvalueLabel, 1, 1, 3, 1);
        Label evtypeLabel = new Label("Event Type: ");
        GridPane.setHalignment(evtypeLabel, HPos.LEFT);
        gridPane.add(evtypeLabel, 0, 2, 1, 1);
        Label evtypevalueLabel = new Label(evtype);
        GridPane.setHalignment(evtypevalueLabel, HPos.LEFT);
        gridPane.add(evtypevalueLabel, 1, 2, 2, 1);
        Label evnameLabel = new Label("Event Name: ");
        GridPane.setHalignment(evnameLabel, HPos.LEFT);
        gridPane.add(evnameLabel, 0, 3, 1, 1);
        Label evnamevalueLabel = new Label(evname);
        GridPane.setHalignment(evnamevalueLabel, HPos.LEFT);
        gridPane.add(evnamevalueLabel, 1, 3, 2, 1);
        Label timeLabel = new Label("Time: ");
        GridPane.setHalignment(timeLabel, HPos.LEFT);
        gridPane.add(timeLabel, 0, 4, 1, 1);
        Label timevalueLabel = new Label(timestamp);
        GridPane.setHalignment(timevalueLabel, HPos.LEFT);
        gridPane.add(timevalueLabel, 1, 4, 2, 1);
        Label useridLabel = new Label("User ID: ");
        GridPane.setHalignment(useridLabel, HPos.LEFT);
        gridPane.add(useridLabel, 0, 5, 1, 1);
        Label useridvalueLabel = new Label(String.valueOf(userid));
        GridPane.setHalignment(useridvalueLabel, HPos.LEFT);
        gridPane.add(useridvalueLabel, 1, 5, 2, 1);
        Label usernameLabel = new Label("User Name: ");
        GridPane.setHalignment(usernameLabel, HPos.LEFT);
        gridPane.add(usernameLabel, 0, 6, 1, 1);
        Label usernamevalueLabel = new Label(username);
        GridPane.setHalignment(usernamevalueLabel, HPos.LEFT);
        gridPane.add(usernamevalueLabel, 1, 6, 2, 1);
        Label payloadLabel = new Label("Payload: ");
        GridPane.setHalignment(payloadLabel, HPos.LEFT);
        gridPane.add(payloadLabel, 0, 7, 1, 1);
        Label payloadvalueLabel = new Label(payload);
        GridPane.setHalignment(payloadvalueLabel, HPos.LEFT);
        gridPane.add(payloadvalueLabel, 1, 7, 2, 1);
        Button prevButton = new Button("Previous");
        prevButton.setPrefHeight(20.0);
        prevButton.setDefaultButton(true);
        Button newEmpButton = new Button("Next");
        newEmpButton.setPrefHeight(20.0);
        newEmpButton.setDefaultButton(true);
        if (idnumber == min) {
            gridPane.add(newEmpButton, 0, 8, 1, 1);
            GridPane.setHalignment(newEmpButton, HPos.LEFT);
            GridPane.setMargin(newEmpButton, new Insets(2.0, 0.0, 2.0, 0.0));
        } else if (idnumber == max) {
            gridPane.add(prevButton, 0, 8, 1, 1);
            GridPane.setHalignment(prevButton, HPos.LEFT);
            GridPane.setMargin(prevButton, new Insets(2.0, 0.0, 2.0, 0.0));
        } else {
            gridPane.add(prevButton, 0, 8, 1, 1);
            GridPane.setHalignment(prevButton, HPos.LEFT);
            GridPane.setMargin(prevButton, new Insets(2.0, 0.0, 2.0, 0.0));
            gridPane.add(newEmpButton, 1, 8, 1, 1);
            GridPane.setHalignment(newEmpButton, HPos.LEFT);
            GridPane.setMargin(newEmpButton, new Insets(2.0, 0.0, 2.0, 0.0));
        }
        prevButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                int prev = idnumber - 1;
                ViewAuditLogTable.viewAuditLog(gridPane_1, primaryStage, ssn_1, prev);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        newEmpButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                int next = idnumber + 1;
                ViewAuditLogTable.viewAuditLog(gridPane_1, primaryStage, ssn_1, next);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Button viewAuditButton = new Button("View Audit Logs");
        viewAuditButton.setPrefHeight(20.0);
        viewAuditButton.setDefaultButton(true);
        gridPane.add(viewAuditButton, 0, 9, 6, 1);
        GridPane.setHalignment(viewAuditButton, HPos.LEFT);
        GridPane.setMargin(viewAuditButton, new Insets(2.0, 0.0, 2.0, 0.0));
        viewAuditButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                ViewAuditLogTable.viewAuditLogTable(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Button viewEmpButton = new Button("Go Back Home");
        viewEmpButton.setPrefHeight(20.0);
        viewEmpButton.setDefaultButton(true);
        gridPane.add(viewEmpButton, 0, 10, 6, 1);
        GridPane.setHalignment(viewEmpButton, HPos.LEFT);
        GridPane.setMargin(viewEmpButton, new Insets(2.0, 0.0, 2.0, 0.0));
        viewEmpButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.mainPage(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Label manLabel = new Label("Manager Logged In:\n" + ssn_1);
        GridPane.setHalignment(manLabel, HPos.LEFT);
        gridPane.add(manLabel, 0, 11, 2, 1);
    }

    private static ObservableList<AuditLogTable> getAuditList() {
        String id = "";
        String evtype = "";
        String evname = "";
        String time = "";
        String userid = "";
        String username = "";
        String payload = "";
        String sql = "SELECT AL_ID_NUMBER AS NUM, AL_EVENT_TYPE AS EVENT_TYPE, AL_EVENT_NAME AS EVENT_NAME,\r\nAL_CREATE_TIME AS TIME, AL_USER_ID AS USERID, AL_USER_NAME AS USERNAME, AL_PAYLOAD AS PAYLOAD \r\nFROM AL_RECORDS";
        ArrayList<AuditLogTable> ml = new ArrayList<AuditLogTable>();
        try {
            Connection conn = MainAccess.LocalinitialSetup(2);
            Statement st = conn.createStatement();
            ResultSet res = st.executeQuery(sql);
            while (res.next()) {
                id = String.valueOf(res.getInt("NUM"));
                evtype = res.getString("EVENT_TYPE");
                evname = res.getString("EVENT_NAME");
                time = res.getString("TIME");
                userid = String.valueOf(res.getInt("USERID"));
                username = res.getString("USERNAME");
                payload = res.getString("PAYLOAD");
                AuditLogTable user1 = new AuditLogTable(id, evtype, evname, time, userid, username, payload);
                ml.add(user1);
            }
            res.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        ObservableList<AuditLogTable> list = null;
        list = FXCollections.observableArrayList();
        for (AuditLogTable o : ml) {
            list.add(o);
        }
        return list;
    }
}

