/*
 * Decompiled with CFR 0.152.
 */
package com.company_project;

import com.company_project.AuditLog;
import com.company_project.UserAccount;
import com.company_project.ViewAuditLogTable;
import com.company_project.editUserAccount;
import com.company_project.newTable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.PrinterJob;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class MainAccess
extends Application {
    static int empssn = 0;
    static int mangssn = 0;
    private static final String DATABASE_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static final String DATABASE_URL = "jdbc:mysql://database-1.cubekapygb35.us-east-1.rds.amazonaws.com:3306/Company";
    private static final String DATABASE_URL_2 = "jdbc:mysql://database-1.cubekapygb35.us-east-1.rds.amazonaws.com:3306";
    private static final String DATABASE_URL_3 = "jdbc:mysql://database-1.cubekapygb35.us-east-1.rds.amazonaws.com:3306/Audit_Log";
    private static final String USERNAME = "appuser";
    private static final String PASSWORD = "ironman129";
    private static final String MAX_POOL = "250";
    private static final int masterssn = 444444400;
    private static Connection connection;
    private static Properties properties;

    @Override
    public void start(Stage primaryStage) throws Exception {
        primaryStage.setTitle("Employee Mangement System JavaFX Application");
        GridPane gridPane = MainAccess.createRegistrationFormPane();
        MainAccess.managerLogin(gridPane, primaryStage);
        ScrollPane sp = new ScrollPane(gridPane);
        Scene scene = new Scene(sp, 800.0, 500.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public static void initialSetup(int flag) {
        try {
            Class.forName(DATABASE_DRIVER);
            MainAccess.connect(flag);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    public static Connection LocalinitialSetup(int option) {
        Connection conn = null;
        try {
            Class.forName(DATABASE_DRIVER);
            conn = MainAccess.Localconnect(option);
            return conn;
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            return null;
        }
    }

    private static Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            properties.setProperty("user", USERNAME);
            properties.setProperty("password", PASSWORD);
            properties.setProperty("MaxPooledStatements", MAX_POOL);
        }
        return properties;
    }

    public static Connection Localconnect(int option) {
        Connection connection = null;
        try {
            Class.forName(DATABASE_DRIVER);
            if (option == 1) {
                connection = DriverManager.getConnection(DATABASE_URL, MainAccess.getProperties());
            } else if (option == 0) {
                connection = DriverManager.getConnection(DATABASE_URL_2, MainAccess.getProperties());
            } else if (option == 2) {
                connection = DriverManager.getConnection(DATABASE_URL_3, MainAccess.getProperties());
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return connection;
    }

    public static Connection connect(int flag) {
        if (connection == null) {
            try {
                Class.forName(DATABASE_DRIVER);
                if (flag == 0) {
                    connection = DriverManager.getConnection(DATABASE_URL, MainAccess.getProperties());
                } else if (flag == 2) {
                    connection = DriverManager.getConnection(DATABASE_URL_3, MainAccess.getProperties());
                }
            }
            catch (ClassNotFoundException | SQLException e) {
                e.printStackTrace();
            }
        }
        return connection;
    }

    public void disconnect() {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static GridPane createRegistrationFormPane() {
        GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER_LEFT);
        gridPane.setPadding(new Insets(40.0, 40.0, 40.0, 40.0));
        gridPane.setHgap(10.0);
        gridPane.setVgap(15.0);
        ColumnConstraints columnOneConstraints = new ColumnConstraints(100.0, 100.0, Double.MAX_VALUE);
        columnOneConstraints.setHalignment(HPos.RIGHT);
        ColumnConstraints columnTwoConstrains = new ColumnConstraints(200.0, 200.0, Double.MAX_VALUE);
        columnTwoConstrains.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{columnOneConstraints});
        return gridPane;
    }

    private static void managerLogin(final GridPane gridPane, final Stage primaryStage) {
        Label headerLabel = new Label("Manager Login");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 2, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        Label fnameLabel = new Label("Please enter your Social Security #:\n(You can use 444444400 for testing) ");
        GridPane.setHalignment(fnameLabel, HPos.LEFT);
        gridPane.add(fnameLabel, 0, 1, 3, 1);
        final TextField ssnField = new TextField(String.valueOf(444444400));
        ssnField.setPrefHeight(40.0);
        ssnField.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    ssnField.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        gridPane.add(ssnField, 0, 2, 3, 1);
        final CheckBox newTableCheckBox = new CheckBox("Check to reload COMPANY table in database");
        newTableCheckBox.setSelected(true);
        GridPane.setHalignment(newTableCheckBox, HPos.LEFT);
        gridPane.add(newTableCheckBox, 0, 3, 2, 1);
        Button submitButton = new Button("Submit");
        submitButton.setPrefHeight(40.0);
        submitButton.setDefaultButton(true);
        submitButton.setPrefWidth(100.0);
        gridPane.add(submitButton, 0, 4, 2, 1);
        GridPane.setHalignment(submitButton, HPos.LEFT);
        GridPane.setMargin(submitButton, new Insets(20.0, 0.0, 20.0, 0.0));
        submitButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                int newtableoption = 1;
                if (ssnField.getText().isEmpty()) {
                    MainAccess.showAlert(Alert.AlertType.ERROR, gridPane.getScene().getWindow(), "Form Error!", "Please enter your Social Security #");
                    return;
                }
                newtableoption = newTableCheckBox.isSelected() ? 0 : 1;
                boolean check = MainAccess.validateManager(Integer.valueOf(ssnField.getText()), newtableoption, 444444400);
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                if (check) {
                    AuditLog.createAuditLog(Integer.valueOf(ssnField.getText()), Integer.valueOf(ssnField.getText()), 12);
                    MainAccess.mainPage(gridPane_1, primaryStage, Integer.valueOf(ssnField.getText()));
                    ScrollPane sp = new ScrollPane(gridPane_1);
                    Scene scene = new Scene(sp, 800.0, 500.0);
                    primaryStage.setScene(scene);
                    primaryStage.show();
                } else {
                    MainAccess.stopScreen(gridPane_1, primaryStage);
                    ScrollPane sp = new ScrollPane(gridPane_1);
                    Scene scene = new Scene(sp, 800.0, 500.0);
                    primaryStage.setScene(scene);
                    primaryStage.show();
                }
            }
        });
    }

    public static void mainPage(final GridPane gridPane, final Stage primaryStage, final int ssn_1) {
        Label headerLabel = new Label("Company Employee HR System");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 5, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        Button newEmpButton = new Button("Add New Employee");
        newEmpButton.setPrefHeight(20.0);
        newEmpButton.setDefaultButton(true);
        gridPane.add(newEmpButton, 0, 2, 6, 1);
        GridPane.setHalignment(newEmpButton, HPos.LEFT);
        GridPane.setMargin(newEmpButton, new Insets(2.0, 0.0, 2.0, 0.0));
        newEmpButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.newEmployee(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Button viewEmpButton = new Button("View All Employees");
        viewEmpButton.setPrefHeight(20.0);
        viewEmpButton.setDefaultButton(true);
        gridPane.add(viewEmpButton, 0, 3, 6, 1);
        GridPane.setHalignment(viewEmpButton, HPos.LEFT);
        GridPane.setMargin(viewEmpButton, new Insets(2.0, 0.0, 2.0, 0.0));
        viewEmpButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.viewEmployeeTable(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Button viewAuditButton = new Button("View Audit Logs");
        viewAuditButton.setPrefHeight(20.0);
        viewAuditButton.setDefaultButton(true);
        gridPane.add(viewAuditButton, 0, 4, 6, 1);
        GridPane.setHalignment(viewAuditButton, HPos.LEFT);
        GridPane.setMargin(viewAuditButton, new Insets(2.0, 0.0, 2.0, 0.0));
        viewAuditButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                ViewAuditLogTable.viewAuditLogTable(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Button signoutButton = new Button("Sign Out");
        signoutButton.setPrefHeight(20.0);
        signoutButton.setDefaultButton(true);
        gridPane.add(signoutButton, 0, 5, 6, 1);
        GridPane.setHalignment(signoutButton, HPos.LEFT);
        GridPane.setMargin(signoutButton, new Insets(2.0, 0.0, 2.0, 0.0));
        signoutButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                MainAccess.showAlert(Alert.AlertType.CONFIRMATION, gridPane.getScene().getWindow(), "Manager Signed Out: ", String.valueOf(ssn_1));
                AuditLog.createAuditLog(ssn_1, ssn_1, 13);
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.managerLogin(gridPane_1, primaryStage);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Label manLabel = new Label("Manager Logged In:\n" + ssn_1);
        GridPane.setHalignment(manLabel, HPos.LEFT);
        gridPane.add(manLabel, 0, 7, 2, 1);
    }

    private static void stopScreen(GridPane gridPane, final Stage primaryStage) {
        Label headerLabel = new Label("Manager Login");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 2, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        Label fnameLabel = new Label("Program has stopped because the SSN you entered isn't valid");
        GridPane.setHalignment(fnameLabel, HPos.LEFT);
        gridPane.add(fnameLabel, 0, 1, 5, 1);
        Button submitButton = new Button("Try Again");
        submitButton.setPrefHeight(40.0);
        submitButton.setDefaultButton(true);
        submitButton.setPrefWidth(100.0);
        gridPane.add(submitButton, 0, 2, 2, 1);
        GridPane.setHalignment(submitButton, HPos.LEFT);
        GridPane.setMargin(submitButton, new Insets(20.0, 0.0, 20.0, 0.0));
        submitButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.managerLogin(gridPane_1, primaryStage);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
    }

    private static boolean validateManager(int superssn, int option, int masterssn) {
        boolean check = false;
        int num = superssn;
        if (option == 0) {
            newTable.createTable();
            AuditLog.createAuditLog(superssn, superssn, 7);
        }
        if (superssn == masterssn) {
            check = true;
            mangssn = superssn;
            System.out.println("Your SSN is VALID");
        } else {
            Connection conn = MainAccess.LocalinitialSetup(1);
            String sql1 = "Select distinct superssn AS SSN\r\nFROM EMPLOYEE";
            try {
                Statement st = conn.createStatement();
                ResultSet res = st.executeQuery(sql1);
                while (res.next()) {
                    int ssn = res.getInt("SSN");
                    if (ssn != num) continue;
                    check = true;
                    break;
                }
                if (!check) {
                    System.out.println("Your SSN is NOT VALID.");
                } else {
                    mangssn = num;
                    System.out.println("Your SSN is VALID");
                }
                res.close();
                st.close();
                conn.close();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        return check;
    }

    public static void assignProject(final GridPane gridPane, final Stage primaryStage, int ssn_1, final int emp_ssn) {
        ResultSet res;
        Statement st;
        Label headerLabel = new Label("Assign Employee to Projects Form");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 4, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        final int ssn = ssn_1;
        Label fnameLabel = new Label("Select project to assign to:");
        GridPane.setHalignment(fnameLabel, HPos.LEFT);
        gridPane.add(fnameLabel, 0, 1, 2, 1);
        Label fnameLabel2 = new Label("Enter Hours:");
        GridPane.setHalignment(fnameLabel2, HPos.LEFT);
        gridPane.add(fnameLabel2, 3, 1, 2, 1);
        final ArrayList<String> project_names = new ArrayList<String>();
        final ArrayList<Integer> project_numbers = new ArrayList<Integer>();
        String sql1 = "SELECT pname AS NAME, pnumber AS NUMB FROM PROJECT";
        try {
            Connection conn = MainAccess.LocalinitialSetup(1);
            st = conn.createStatement();
            res = st.executeQuery(sql1);
            while (res.next()) {
                String name = res.getString("NAME");
                project_names.add(name);
            }
            res.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        try {
            Connection conn2 = MainAccess.LocalinitialSetup(1);
            st = conn2.createStatement();
            res = st.executeQuery(sql1);
            while (res.next()) {
                int number = res.getInt("NUMB");
                project_numbers.add(number);
            }
            res.close();
            st.close();
            conn2.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        final CheckBox[] cbs = new CheckBox[project_names.size()];
        final TextField[] project_hours = new TextField[project_names.size()];
        int n = 3;
        int i = 0;
        while (i < project_names.size()) {
            CheckBox cb = cbs[i] = new CheckBox((String)project_names.get(i));
            GridPane.setHalignment(cb, HPos.LEFT);
            gridPane.add(cb, 0, n, 2, 1);
            TextField b = project_hours[i] = new TextField();
            b.setPrefHeight(40.0);
            GridPane.setHalignment(b, HPos.LEFT);
            gridPane.add(b, 3, n, 2, 1);
            ++n;
            ++i;
        }
        Button submitButton = new Button("Submit");
        submitButton.setPrefHeight(40.0);
        submitButton.setDefaultButton(true);
        submitButton.setPrefWidth(100.0);
        gridPane.add(submitButton, 0, ++n, 2, 1);
        GridPane.setHalignment(submitButton, HPos.LEFT);
        GridPane.setMargin(submitButton, new Insets(20.0, 0.0, 20.0, 0.0));
        Label manLabel = new Label("Manager Logged In:\n" + ssn + "\n\nEmployee being edited:\n" + empssn);
        GridPane.setHalignment(manLabel, HPos.LEFT);
        gridPane.add(manLabel, 0, ++n, 2, 1);
        submitButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                int total = 0;
                int i = 0;
                while (i < project_names.size()) {
                    if (cbs[i].isSelected()) {
                        int a = 0;
                        if (project_hours[i].getText() == "") {
                            a = 0;
                        } else {
                            String s = project_hours[i].getText();
                            double d = MainAccess.ParseDouble(s);
                            a = (int)d;
                        }
                        total += a;
                    }
                    ++i;
                }
                if (total > 40) {
                    MainAccess.showAlert(Alert.AlertType.ERROR, gridPane.getScene().getWindow(), "Too many hours!", "Please reduce the amount of hours");
                    return;
                }
                boolean check = false;
                int i2 = 0;
                while (i2 < project_names.size()) {
                    if (cbs[i2].isSelected()) {
                        check = true;
                        break;
                    }
                    ++i2;
                }
                if (!check) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Warning");
                    alert.setHeaderText("No projects selected.");
                    alert.setResizable(false);
                    alert.setContentText("Select okay to continue or cancel to go back.");
                    Optional result = alert.showAndWait();
                    ButtonType button = result.orElse(ButtonType.CANCEL);
                    if (button == ButtonType.OK) {
                        System.out.println("Ok pressed on assigned project");
                    } else {
                        System.out.println("Canceled pressed on assigned project");
                        return;
                    }
                }
                try {
                    int k = 0;
                    while (k < project_names.size()) {
                        int p = 0;
                        try {
                            p = Integer.valueOf(project_hours[k].getText());
                        }
                        catch (Exception e3) {
                            int a;
                            String s = project_hours[k].getText();
                            double d = MainAccess.ParseDouble(s);
                            p = a = (int)d;
                        }
                        if (cbs[k].isSelected() && p > 0 && project_hours[k].getText() != "") {
                            Connection conn = MainAccess.LocalinitialSetup(1);
                            Statement st = null;
                            PreparedStatement pt = null;
                            String sql = "";
                            st = conn.createStatement();
                            sql = "INSERT INTO WORKS_ON VALUES (?, ?, ?)";
                            pt = conn.prepareStatement(sql);
                            String string_ssn = String.valueOf(emp_ssn);
                            if (string_ssn != "") {
                                pt.setString(1, string_ssn);
                            } else {
                                pt.setNull(1, 12);
                            }
                            pt.setInt(2, (Integer)project_numbers.get(k));
                            if (project_hours[k].getText() != "") {
                                try {
                                    pt.setInt(3, Integer.valueOf(project_hours[k].getText()));
                                }
                                catch (Exception e) {
                                    String s = project_hours[k].getText();
                                    double d = MainAccess.ParseDouble(s);
                                    int a = (int)d;
                                    pt.setInt(3, a);
                                }
                            } else {
                                pt.setNull(3, 4);
                            }
                            pt.executeUpdate();
                            AuditLog.createAuditLog(emp_ssn, ssn, 5);
                            pt.close();
                            st.close();
                            conn.close();
                        }
                        ++k;
                    }
                }
                catch (Exception ex) {
                    MainAccess.showAlert(Alert.AlertType.CONFIRMATION, gridPane.getScene().getWindow(), "New Employee NOT added to any projects!", "Please try again.\n" + ex);
                    System.err.println(ex);
                    return;
                }
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.employeeDependents(gridPane_1, primaryStage, ssn, empssn);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
    }

    private static void employeeDependents(final GridPane gridPane, final Stage primaryStage, final int ssn_1, final int emp_ssn) {
        Label headerLabel = new Label("Employee Dependents Form");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 5, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        int ssn = ssn_1;
        Label fnameLabel = new Label("Does the employee have any dependents?");
        GridPane.setHalignment(fnameLabel, HPos.LEFT);
        gridPane.add(fnameLabel, 0, 1, 2, 1);
        final CheckBox yes = new CheckBox("Yes");
        GridPane.setHalignment(yes, HPos.LEFT);
        gridPane.add(yes, 0, 2, 2, 1);
        final CheckBox no = new CheckBox("No");
        GridPane.setHalignment(no, HPos.LEFT);
        gridPane.add(no, 0, 3, 2, 1);
        EventHandler<ActionEvent> eh = new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                if (event.getSource() instanceof CheckBox) {
                    CheckBox chk = (CheckBox)event.getSource();
                    Label manLabel = new Label("Please enter dependents");
                    Label manLabel2 = new Label("Proceed to next screen");
                    if ("Yes".equals(chk.getText())) {
                        no.setSelected(!chk.isSelected());
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 4);
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 5);
                        GridPane.setHalignment(manLabel, HPos.LEFT);
                        gridPane.add(manLabel, 0, 4, 2, 1);
                        Label nameLabel = new Label("First name : ");
                        gridPane.add(nameLabel, 0, 5);
                        final TextField nameField = new TextField("");
                        nameField.setPrefHeight(40.0);
                        gridPane.add(nameField, 1, 5);
                        Label sexLabel = new Label("Sex : ");
                        gridPane.add(sexLabel, 0, 6);
                        ToggleGroup sexgroup = new ToggleGroup();
                        final RadioButton male = new RadioButton("Male");
                        male.setToggleGroup(sexgroup);
                        final RadioButton female = new RadioButton("Female");
                        female.setToggleGroup(sexgroup);
                        male.setSelected(true);
                        GridPane.setHalignment(male, HPos.LEFT);
                        gridPane.add(male, 1, 6);
                        female.setSelected(false);
                        GridPane.setHalignment(female, HPos.LEFT);
                        gridPane.add(female, 1, 7);
                        Label bLabel = new Label("Birthday :\n(YYYY-MM-DD) ");
                        gridPane.add(bLabel, 0, 8);
                        final DatePicker datePicker = new DatePicker();
                        datePicker.setOnAction(event1 -> {
                            LocalDate date = (LocalDate)datePicker.getValue();
                            System.out.println("Selected date: " + date);
                        });
                        String pattern = "yyyy-MM-dd";
                        datePicker.setPromptText(pattern.toLowerCase());
                        datePicker.setConverter(new StringConverter<LocalDate>(pattern){
                            DateTimeFormatter dateFormatter;
                            {
                                this.dateFormatter = DateTimeFormatter.ofPattern(string);
                            }

                            @Override
                            public String toString(LocalDate date) {
                                if (date != null) {
                                    return this.dateFormatter.format(date);
                                }
                                return "";
                            }

                            @Override
                            public LocalDate fromString(String string) {
                                if (string != null && !string.isEmpty()) {
                                    return LocalDate.parse(string, this.dateFormatter);
                                }
                                return null;
                            }
                        });
                        datePicker.setPrefHeight(40.0);
                        gridPane.add(datePicker, 1, 8);
                        Label rLabel = new Label("Relation : ");
                        gridPane.add(rLabel, 0, 9);
                        final TextField rField = new TextField("");
                        rField.setPrefHeight(40.0);
                        gridPane.add(rField, 1, 9);
                        Button submitButton = new Button("Submit");
                        submitButton.setPrefHeight(40.0);
                        submitButton.setDefaultButton(true);
                        submitButton.setPrefWidth(100.0);
                        gridPane.add(submitButton, 0, 10, 2, 1);
                        GridPane.setHalignment(submitButton, HPos.LEFT);
                        GridPane.setMargin(submitButton, new Insets(20.0, 0.0, 20.0, 0.0));
                        submitButton.setOnAction(new EventHandler<ActionEvent>(){

                            @Override
                            public void handle(ActionEvent event) {
                                if (nameField.getText().isEmpty()) {
                                    MainAccess.showAlert(Alert.AlertType.ERROR, gridPane.getScene().getWindow(), "Form Error!", "Please enter the dependent's first name");
                                    return;
                                }
                                String essn = String.valueOf(emp_ssn);
                                String depname = nameField.getText();
                                String sex = "";
                                if (male.isSelected()) {
                                    sex = "M";
                                } else if (female.isSelected()) {
                                    sex = "F";
                                }
                                String bday = String.valueOf(datePicker.getValue());
                                String relation = rField.getText();
                                try {
                                    Connection conn = MainAccess.LocalinitialSetup(1);
                                    Statement st = conn.createStatement();
                                    String sql = "INSERT INTO DEPENDENT VALUES (?, ?, ?, ?, ?)";
                                    PreparedStatement pt = conn.prepareStatement(sql);
                                    if (essn != "") {
                                        pt.setString(1, essn);
                                    } else {
                                        pt.setNull(1, 12);
                                    }
                                    if (depname != "") {
                                        pt.setString(2, depname);
                                    } else {
                                        pt.setNull(2, 12);
                                    }
                                    if (sex != "") {
                                        pt.setString(3, sex);
                                    } else {
                                        pt.setNull(3, 12);
                                    }
                                    if (bday != "") {
                                        pt.setString(4, bday);
                                    } else {
                                        pt.setNull(4, 12);
                                    }
                                    if (relation != "") {
                                        pt.setString(5, relation);
                                    } else {
                                        pt.setNull(5, 12);
                                    }
                                    pt.executeUpdate();
                                    AuditLog.createAuditLog(emp_ssn, ssn_1, 6);
                                    pt.close();
                                    st.close();
                                    conn.close();
                                    MainAccess.showAlert(Alert.AlertType.CONFIRMATION, gridPane.getScene().getWindow(), "New Dependent Added Successfully!", "Employee's SSN: " + essn + "\nName: " + depname + "\nSex: " + sex + "\nRelation: " + relation);
                                }
                                catch (Exception ex) {
                                    MainAccess.showAlert(Alert.AlertType.CONFIRMATION, gridPane.getScene().getWindow(), "New Dependent NOT Added!", "Please try again.\n" + ex);
                                    System.err.println(ex);
                                    return;
                                }
                            }
                        });
                        Button nextButton = new Button("Next");
                        nextButton.setPrefHeight(40.0);
                        nextButton.setDefaultButton(true);
                        nextButton.setPrefWidth(100.0);
                        gridPane.add(nextButton, 1, 10, 2, 1);
                        GridPane.setHalignment(nextButton, HPos.LEFT);
                        GridPane.setMargin(nextButton, new Insets(20.0, 0.0, 20.0, 0.0));
                        nextButton.setOnAction(new EventHandler<ActionEvent>(){

                            @Override
                            public void handle(ActionEvent event) {
                                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                                MainAccess.finalReport(gridPane_1, primaryStage, ssn_1, emp_ssn);
                                ScrollPane sp = new ScrollPane(gridPane_1);
                                Scene scene = new Scene(sp, 800.0, 500.0);
                                primaryStage.setScene(scene);
                                primaryStage.show();
                            }
                        });
                    } else if ("No".equals(chk.getText())) {
                        yes.setSelected(!chk.isSelected());
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 4);
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 5);
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 6);
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 7);
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 8);
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 9);
                        gridPane.getChildren().removeIf(node -> GridPane.getRowIndex(node) == 10);
                        GridPane.setHalignment(manLabel2, HPos.LEFT);
                        gridPane.add(manLabel2, 0, 4, 2, 1);
                        Button submitButton = new Button("Next");
                        submitButton.setPrefHeight(40.0);
                        submitButton.setDefaultButton(true);
                        submitButton.setPrefWidth(100.0);
                        gridPane.add(submitButton, 0, 5, 2, 1);
                        GridPane.setHalignment(submitButton, HPos.LEFT);
                        GridPane.setMargin(submitButton, new Insets(20.0, 0.0, 20.0, 0.0));
                        submitButton.setOnAction(new EventHandler<ActionEvent>(){

                            @Override
                            public void handle(ActionEvent event) {
                                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                                MainAccess.finalReport(gridPane_1, primaryStage, ssn_1, emp_ssn);
                                ScrollPane sp = new ScrollPane(gridPane_1);
                                Scene scene = new Scene(sp, 800.0, 500.0);
                                primaryStage.setScene(scene);
                                primaryStage.show();
                            }
                        });
                    }
                }
            }
        };
        yes.setOnAction(eh);
        no.setOnAction(eh);
        Label manLabel = new Label("Manager Logged In:\n" + ssn_1 + "\n\nEmployee being edited:\n" + String.valueOf(emp_ssn));
        GridPane.setHalignment(manLabel, HPos.LEFT);
        gridPane.add(manLabel, 0, 11, 2, 1);
    }

    public static void viewEmployeeTable(GridPane gridPane, final Stage primaryStage, final int ssn_1) {
        Label headerLabel = new Label("Current Employees at Company");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 4, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        Label instruction = new Label("Click on row to edit employee");
        GridPane.setHalignment(instruction, HPos.LEFT);
        gridPane.add(instruction, 0, 1, 4, 1);
        final TableView<UserAccount> table = new TableView<UserAccount>();
        TableColumn ssnNameCol = new TableColumn("SSN");
        TableColumn firstNameCol = new TableColumn("First Name");
        TableColumn midNameCol = new TableColumn("Middle Initial");
        TableColumn lastNameCol = new TableColumn("Last Name");
        TableColumn addNameCol = new TableColumn("Address");
        TableColumn sexNameCol = new TableColumn("Sex");
        TableColumn dobNameCol = new TableColumn("DOB");
        TableColumn salNameCol = new TableColumn("Salary");
        TableColumn mgssNameCol = new TableColumn("Manager SSN");
        TableColumn dnoNameCol = new TableColumn("Dept No");
        ssnNameCol.setCellValueFactory(new PropertyValueFactory("ssn"));
        firstNameCol.setCellValueFactory(new PropertyValueFactory("firstname"));
        midNameCol.setCellValueFactory(new PropertyValueFactory("midinit"));
        lastNameCol.setCellValueFactory(new PropertyValueFactory("lastname"));
        addNameCol.setCellValueFactory(new PropertyValueFactory("address"));
        sexNameCol.setCellValueFactory(new PropertyValueFactory("sex"));
        dobNameCol.setCellValueFactory(new PropertyValueFactory("dob"));
        salNameCol.setCellValueFactory(new PropertyValueFactory("salary"));
        mgssNameCol.setCellValueFactory(new PropertyValueFactory("mgssn"));
        dnoNameCol.setCellValueFactory(new PropertyValueFactory("dno"));
        ObservableList<UserAccount> list = MainAccess.getUserList();
        table.setItems(list);
        table.getColumns().addAll(ssnNameCol, firstNameCol, midNameCol, lastNameCol, addNameCol, sexNameCol, dobNameCol, salNameCol, mgssNameCol, dnoNameCol);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        table.setOnMousePressed(new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent event) {
                System.out.println(((UserAccount)table.getSelectionModel().getSelectedItem()).getSsn());
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                editUserAccount.editEmployee(gridPane_1, primaryStage, ssn_1, Integer.parseInt(((UserAccount)table.getSelectionModel().getSelectedItem()).getSsn()));
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        StackPane root = new StackPane();
        root.setPadding(new Insets(5.0));
        root.getChildren().add(table);
        gridPane.add(root, 0, 2, 10, 1);
        Label manLabel = new Label("Manager Logged In:\n" + ssn_1);
        GridPane.setHalignment(manLabel, HPos.LEFT);
        gridPane.add(manLabel, 0, 3, 2, 1);
        Button homeButton = new Button("Go Back Home");
        homeButton.setPrefHeight(20.0);
        homeButton.setDefaultButton(true);
        gridPane.add(homeButton, 0, 4, 6, 1);
        GridPane.setHalignment(homeButton, HPos.LEFT);
        GridPane.setMargin(homeButton, new Insets(2.0, 0.0, 2.0, 0.0));
        homeButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.mainPage(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
    }

    private static ObservableList<UserAccount> getUserList() {
        String ssn = "";
        String fname = "";
        String lname = "";
        String mint = "";
        String dob = "";
        String addr = "";
        String sex = "";
        String salary = "";
        String superssn = "";
        String dno = "";
        String sql = "SELECT ssn as SSN, fname AS FIRST_NAME, lname AS LAST_NAME, minit AS M_NAME,\r\nbdate AS BDAY, address AS ADDRESS_1, sex AS SEX_1, salary AS SAL, superssn AS SUPER,\r\ndno AS DEPT\r\nFROM EMPLOYEE";
        ArrayList<UserAccount> ml = new ArrayList<UserAccount>();
        try {
            Connection conn = MainAccess.LocalinitialSetup(1);
            Statement st = conn.createStatement();
            ResultSet res = st.executeQuery(sql);
            while (res.next()) {
                ssn = String.valueOf(res.getInt("SSN"));
                fname = res.getString("FIRST_NAME");
                lname = res.getString("LAST_NAME");
                mint = res.getString("M_NAME");
                dob = res.getString("BDAY");
                addr = res.getString("ADDRESS_1");
                sex = res.getString("SEX_1");
                salary = String.valueOf(res.getInt("SAL"));
                superssn = res.getString("SUPER");
                dno = String.valueOf(res.getInt("DEPT"));
                UserAccount user1 = new UserAccount(ssn, fname, mint, lname, addr, sex, dob, salary, superssn, dno);
                ml.add(user1);
            }
            res.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        ObservableList<UserAccount> list = null;
        list = FXCollections.observableArrayList();
        for (UserAccount o : ml) {
            list.add(o);
        }
        return list;
    }

    private static void newEmployee(final GridPane gridPane, final Stage primaryStage, final int mgssn) {
        Label headerLabel = new Label("New Employee Form");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 2, 1);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        Label fnameLabel = new Label("First Name : ");
        gridPane.add(fnameLabel, 0, 1);
        final TextField fnameField = new TextField("");
        fnameField.setPrefHeight(40.0);
        gridPane.add(fnameField, 1, 1);
        Label lnameLabel = new Label("Last Name : ");
        gridPane.add(lnameLabel, 0, 2);
        final TextField lnameField = new TextField("");
        lnameField.setPrefHeight(40.0);
        gridPane.add(lnameField, 1, 2);
        Label mnameLabel = new Label("Middle Initial : ");
        gridPane.add(mnameLabel, 0, 3);
        final TextField mnameField = new TextField("");
        mnameField.setPrefHeight(40.0);
        gridPane.add(mnameField, 1, 3);
        Label ssnLabel = new Label("Social Security # : ");
        gridPane.add(ssnLabel, 0, 4);
        final TextField ssnField = new TextField();
        ssnField.setPrefHeight(40.0);
        ssnField.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    ssnField.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        gridPane.add(ssnField, 1, 4);
        Label dobLabel = new Label("Date of Birth :\n (YYYY-MM-DD) ");
        gridPane.add(dobLabel, 0, 5);
        final DatePicker datePicker = new DatePicker();
        datePicker.setOnAction(event -> {
            LocalDate date = (LocalDate)datePicker.getValue();
            System.out.println("Selected date: " + date);
        });
        String pattern = "yyyy-MM-dd";
        datePicker.setPromptText(pattern.toLowerCase());
        datePicker.setConverter(new StringConverter<LocalDate>(pattern){
            DateTimeFormatter dateFormatter;
            {
                this.dateFormatter = DateTimeFormatter.ofPattern(string);
            }

            @Override
            public String toString(LocalDate date) {
                if (date != null) {
                    return this.dateFormatter.format(date);
                }
                return "";
            }

            @Override
            public LocalDate fromString(String string) {
                if (string != null && !string.isEmpty()) {
                    return LocalDate.parse(string, this.dateFormatter);
                }
                return null;
            }
        });
        datePicker.setPrefHeight(40.0);
        gridPane.add(datePicker, 1, 5);
        Label addrLabel = new Label("Address : ");
        gridPane.add(addrLabel, 0, 6);
        final TextField addrField = new TextField("");
        addrField.setPrefHeight(40.0);
        gridPane.add(addrField, 1, 6);
        Label sexLabel = new Label("Sex : ");
        gridPane.add(sexLabel, 0, 7);
        ToggleGroup sexgroup = new ToggleGroup();
        final RadioButton male = new RadioButton("Male");
        male.setToggleGroup(sexgroup);
        final RadioButton female = new RadioButton("Female");
        female.setToggleGroup(sexgroup);
        male.setSelected(true);
        GridPane.setHalignment(male, HPos.LEFT);
        gridPane.add(male, 1, 7);
        female.setSelected(false);
        GridPane.setHalignment(female, HPos.LEFT);
        gridPane.add(female, 1, 8);
        Label salaryLabel = new Label("Salary : ");
        gridPane.add(salaryLabel, 0, 9);
        final TextField salaryField = new TextField("");
        salaryField.setPrefHeight(40.0);
        gridPane.add(salaryField, 1, 9);
        Label superLabel = new Label("Supervisor's SSN : ");
        gridPane.add(superLabel, 0, 10);
        final TextField superField = new TextField("");
        superField.setPrefHeight(40.0);
        superField.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    superField.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        gridPane.add(superField, 1, 10);
        Label depLabel = new Label("Dept # : ");
        gridPane.add(depLabel, 0, 11);
        final TextField depField = new TextField("");
        depField.setPrefHeight(40.0);
        depField.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    depField.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        gridPane.add(depField, 1, 11);
        Button submitButton = new Button("Submit");
        submitButton.setPrefHeight(40.0);
        submitButton.setDefaultButton(true);
        submitButton.setPrefWidth(100.0);
        gridPane.add(submitButton, 1, 12, 2, 1);
        GridPane.setHalignment(submitButton, HPos.LEFT);
        GridPane.setMargin(submitButton, new Insets(20.0, 0.0, 20.0, 0.0));
        Button homeButton = new Button("Go Back Home");
        homeButton.setPrefHeight(20.0);
        homeButton.setDefaultButton(true);
        gridPane.add(homeButton, 1, 13, 4, 1);
        GridPane.setHalignment(homeButton, HPos.LEFT);
        GridPane.setMargin(homeButton, new Insets(2.0, 0.0, 2.0, 0.0));
        homeButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.mainPage(gridPane_1, primaryStage, mgssn);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        Label manLabel = new Label("Manager Logged In:\n" + mangssn);
        gridPane.add(manLabel, 1, 15, 2, 1);
        submitButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                int a;
                if (fnameField.getText().isEmpty()) {
                    MainAccess.showAlert(Alert.AlertType.ERROR, gridPane.getScene().getWindow(), "Form Error!", "Please enter your first name");
                    return;
                }
                if (lnameField.getText().isEmpty()) {
                    MainAccess.showAlert(Alert.AlertType.ERROR, gridPane.getScene().getWindow(), "Form Error!", "Please enter your last name");
                    return;
                }
                if (ssnField.getText().isEmpty()) {
                    MainAccess.showAlert(Alert.AlertType.ERROR, gridPane.getScene().getWindow(), "Form Error!", "Please enter your Social Security #");
                    return;
                }
                String fname = fnameField.getText();
                String lname = lnameField.getText();
                String mint = mnameField.getText();
                String ssn = ssnField.getText();
                String dob = String.valueOf(datePicker.getValue());
                String addr = addrField.getText();
                String sex = "";
                if (male.isSelected()) {
                    sex = "M";
                } else if (female.isSelected()) {
                    sex = "F";
                }
                int salary = 0;
                String s = salaryField.getText();
                double d = MainAccess.ParseDouble(s);
                salary = a = (int)d;
                String superssn = superField.getText();
                int dno = Integer.valueOf(depField.getText());
                try {
                    Connection conn = MainAccess.LocalinitialSetup(1);
                    Statement st = conn.createStatement();
                    String sql = "INSERT INTO EMPLOYEE VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    PreparedStatement pt = conn.prepareStatement(sql);
                    if (fname != "") {
                        pt.setString(1, fname);
                    } else {
                        pt.setNull(1, 12);
                    }
                    if (lname != "") {
                        pt.setString(3, lname);
                    } else {
                        pt.setNull(3, 12);
                    }
                    if (mint != "") {
                        pt.setString(2, mint);
                    } else {
                        pt.setNull(2, 12);
                    }
                    if (ssn != "") {
                        pt.setString(4, ssn);
                    } else {
                        pt.setNull(4, 12);
                    }
                    if (dob != "") {
                        pt.setString(5, dob);
                    } else {
                        pt.setNull(5, 91);
                    }
                    if (addr != "") {
                        pt.setString(6, addr);
                    } else {
                        pt.setNull(6, 12);
                    }
                    if (sex != "") {
                        pt.setString(7, sex);
                    } else {
                        pt.setNull(7, 12);
                    }
                    if (salary >= 0) {
                        pt.setInt(8, salary);
                    } else {
                        pt.setNull(8, 4);
                    }
                    if (superssn != "") {
                        pt.setString(9, superssn);
                    } else {
                        pt.setNull(9, 12);
                    }
                    if (dno >= 0) {
                        pt.setInt(10, dno);
                    } else {
                        pt.setNull(10, 4);
                    }
                    pt.executeUpdate();
                    AuditLog.createAuditLog(Integer.valueOf(ssn), mangssn, 4);
                    pt.close();
                    st.close();
                    conn.close();
                    MainAccess.showAlert(Alert.AlertType.CONFIRMATION, gridPane.getScene().getWindow(), "New Employee Added Successfully!", "Name: " + fnameField.getText());
                    empssn = Integer.valueOf(ssn);
                }
                catch (Exception ex) {
                    MainAccess.showAlert(Alert.AlertType.CONFIRMATION, gridPane.getScene().getWindow(), "New Employee NOT Added!", "Please try again.\n" + ex);
                    System.err.println(ex);
                    return;
                }
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.assignProject(gridPane_1, primaryStage, mangssn, Integer.parseInt(ssn));
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
    }

    public static void showAlert(Alert.AlertType alertType, Window owner, String title, String message) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.initOwner(owner);
        alert.show();
    }

    public static void finalReport(final GridPane gridPane, final Stage primaryStage, final int ssn_1, int emp_ssn) {
        ArrayList<Label> report = new ArrayList<Label>();
        Label headerLabel = new Label("Final Report for Employee");
        headerLabel.setFont(Font.font("Arial", FontWeight.BOLD, 24.0));
        gridPane.add(headerLabel, 0, 0, 4, 1);
        report.add(headerLabel);
        GridPane.setHalignment(headerLabel, HPos.LEFT);
        GridPane.setMargin(headerLabel, new Insets(20.0, 0.0, 20.0, 0.0));
        String ssn = String.valueOf(emp_ssn);
        String fname = "";
        String lname = "";
        String mint = "";
        String dob = "";
        String addr = "";
        String sex = "";
        int salary = 0;
        String superssn = "";
        int dno = 0;
        String sql = "SELECT fname AS FIRST_NAME, lname AS LAST_NAME, minit AS M_NAME,\r\nbdate AS BDAY, address AS ADDRESS_1, sex AS SEX_1, salary AS SAL, superssn AS SUPER,\r\ndno AS DEPT\r\nFROM EMPLOYEE\r\nWHERE ssn = " + ssn;
        try {
            Connection conn = MainAccess.LocalinitialSetup(1);
            Statement st = conn.createStatement();
            ResultSet res = st.executeQuery(sql);
            while (res.next()) {
                fname = res.getString("FIRST_NAME");
                lname = res.getString("LAST_NAME");
                mint = res.getString("M_NAME");
                dob = res.getString("BDAY");
                addr = res.getString("ADDRESS_1");
                sex = res.getString("SEX_1");
                salary = res.getInt("SAL");
                superssn = res.getString("SUPER");
                dno = res.getInt("DEPT");
            }
            res.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Label headerLabel2 = new Label("Employee Information");
        headerLabel2.setFont(Font.font("Arial", FontWeight.BOLD, 18.0));
        gridPane.add(headerLabel2, 0, 1, 4, 1);
        GridPane.setHalignment(headerLabel2, HPos.LEFT);
        Label fnameLabel = new Label("First Name : ");
        GridPane.setHalignment(fnameLabel, HPos.LEFT);
        gridPane.add(fnameLabel, 0, 2);
        Label fnameField = new Label(fname);
        GridPane.setHalignment(fnameField, HPos.LEFT);
        gridPane.add(fnameField, 1, 2);
        Label lnameLabel = new Label("Last Name : ");
        GridPane.setHalignment(lnameLabel, HPos.LEFT);
        gridPane.add(lnameLabel, 0, 3);
        Label lnameField = new Label(lname);
        GridPane.setHalignment(lnameField, HPos.LEFT);
        gridPane.add(lnameField, 1, 3);
        Label mnameLabel = new Label("Middle Initial : ");
        GridPane.setHalignment(mnameLabel, HPos.LEFT);
        gridPane.add(mnameLabel, 0, 4);
        Label mnameField = new Label(mint);
        GridPane.setHalignment(mnameField, HPos.LEFT);
        gridPane.add(mnameField, 1, 4);
        Label ssnLabel = new Label("SSN : ");
        GridPane.setHalignment(ssnLabel, HPos.LEFT);
        gridPane.add(ssnLabel, 0, 5);
        Label ssnField = new Label(ssn);
        GridPane.setHalignment(ssnField, HPos.LEFT);
        gridPane.add(ssnField, 1, 5);
        Label dobLabel = new Label("Date of Birth : ");
        GridPane.setHalignment(dobLabel, HPos.LEFT);
        gridPane.add(dobLabel, 0, 6);
        Label dobField = new Label(dob);
        GridPane.setHalignment(dobField, HPos.LEFT);
        gridPane.add(dobField, 1, 6);
        Label addrLabel = new Label("Address : ");
        GridPane.setHalignment(addrLabel, HPos.LEFT);
        gridPane.add(addrLabel, 0, 7);
        Label addrField = new Label(addr);
        GridPane.setHalignment(addrField, HPos.LEFT);
        gridPane.add(addrField, 1, 7);
        Label sexLabel = new Label("Sex : ");
        GridPane.setHalignment(sexLabel, HPos.LEFT);
        gridPane.add(sexLabel, 0, 8);
        Label sexField = new Label(sex);
        GridPane.setHalignment(sexField, HPos.LEFT);
        gridPane.add(sexField, 1, 8);
        Label salaryLabel = new Label("Salary : ");
        GridPane.setHalignment(salaryLabel, HPos.LEFT);
        gridPane.add(salaryLabel, 0, 9);
        Label salaryField = new Label(String.valueOf(salary));
        GridPane.setHalignment(salaryField, HPos.LEFT);
        gridPane.add(salaryField, 1, 9);
        Label ssLabel = new Label("Super SSN : ");
        GridPane.setHalignment(ssLabel, HPos.LEFT);
        gridPane.add(ssLabel, 0, 10);
        Label ssField = new Label(superssn);
        GridPane.setHalignment(ssField, HPos.LEFT);
        gridPane.add(ssField, 1, 10);
        Label dLabel = new Label("Dept # : ");
        GridPane.setHalignment(dLabel, HPos.LEFT);
        gridPane.add(dLabel, 0, 11);
        Label dField = new Label(String.valueOf(dno));
        GridPane.setHalignment(dField, HPos.LEFT);
        gridPane.add(dField, 1, 11);
        Label headerLabel3 = new Label("Projects and Hours");
        headerLabel3.setFont(Font.font("Arial", FontWeight.BOLD, 18.0));
        gridPane.add(headerLabel3, 0, 13, 3, 1);
        GridPane.setHalignment(headerLabel3, HPos.LEFT);
        Label pLabel = new Label("Project Name");
        pLabel.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
        GridPane.setHalignment(pLabel, HPos.LEFT);
        gridPane.add(pLabel, 0, 14);
        Label wLabel = new Label("Work Hours");
        wLabel.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
        GridPane.setHalignment(wLabel, HPos.LEFT);
        gridPane.add(wLabel, 1, 14);
        String sql2 = "SELECT pname AS PROJ_NAME, hours AS WORK_HOURS\r\nFROM PROJECT, WORKS_ON\r\nWHERE WORKS_ON.essn = " + ssn + " AND WORKS_ON.pno = PROJECT.pnumber";
        String project_name = "";
        int work_hours = 0;
        int n = 15;
        try {
            Connection conn2 = MainAccess.LocalinitialSetup(1);
            Statement st = conn2.createStatement();
            ResultSet res = st.executeQuery(sql2);
            while (res.next()) {
                project_name = res.getString("PROJ_NAME");
                work_hours = res.getInt("WORK_HOURS");
                Label pnLabel = new Label(project_name);
                GridPane.setHalignment(pnLabel, HPos.LEFT);
                gridPane.add(pnLabel, 0, n);
                Label wnLabel = new Label(String.valueOf(work_hours));
                GridPane.setHalignment(wnLabel, HPos.LEFT);
                gridPane.add(wnLabel, 1, n);
                ++n;
            }
            res.close();
            st.close();
            conn2.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Label headerLabel4 = new Label("Dependents");
        headerLabel4.setFont(Font.font("Arial", FontWeight.BOLD, 18.0));
        gridPane.add(headerLabel4, 0, n, 3, 1);
        GridPane.setHalignment(headerLabel4, HPos.LEFT);
        Label nameLabel = new Label("Name");
        nameLabel.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
        GridPane.setHalignment(nameLabel, HPos.LEFT);
        gridPane.add(nameLabel, 0, ++n);
        Label sexLabel2 = new Label("Sex");
        sexLabel2.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
        GridPane.setHalignment(sexLabel2, HPos.LEFT);
        gridPane.add(sexLabel2, 1, n);
        Label dobLabel2 = new Label("Date of Birth");
        dobLabel2.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
        GridPane.setHalignment(dobLabel2, HPos.LEFT);
        gridPane.add(dobLabel2, 2, n);
        Label rLabel2 = new Label("Relationship");
        rLabel2.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
        GridPane.setHalignment(rLabel2, HPos.LEFT);
        gridPane.add(rLabel2, 3, n);
        String sql3 = "SELECT dependent_name AS D_NAME, sex AS D_SEX, bdate AS D_DOB, relationship AS D_REL\r\nFROM DEPENDENT\r\nWHERE essn = " + ssn;
        String dep_name = "";
        String d_sex = "";
        String d_dob = "";
        String d_rel = "";
        ++n;
        try {
            Connection conn3 = MainAccess.LocalinitialSetup(1);
            Statement st2 = conn3.createStatement();
            ResultSet res2 = st2.executeQuery(sql3);
            while (res2.next()) {
                dep_name = res2.getString("D_NAME");
                d_sex = res2.getString("D_SEX");
                d_dob = res2.getString("D_DOB");
                d_rel = res2.getString("D_REL");
                Label dnLabel = new Label(dep_name);
                GridPane.setHalignment(dnLabel, HPos.LEFT);
                gridPane.add(dnLabel, 0, n);
                Label dsLabel = new Label(d_sex);
                GridPane.setHalignment(dsLabel, HPos.LEFT);
                gridPane.add(dsLabel, 1, n);
                Label dbLabel = new Label(d_dob);
                GridPane.setHalignment(dbLabel, HPos.LEFT);
                gridPane.add(dbLabel, 2, n);
                Label drLabel = new Label(d_rel);
                GridPane.setHalignment(drLabel, HPos.LEFT);
                gridPane.add(drLabel, 3, n);
                ++n;
            }
            res2.close();
            st2.close();
            conn3.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Button submitButton = new Button("Print Report");
        submitButton.setPrefHeight(40.0);
        submitButton.setDefaultButton(true);
        submitButton.setPrefWidth(100.0);
        gridPane.add(submitButton, 0, ++n, 1, 1);
        GridPane.setHalignment(submitButton, HPos.LEFT);
        GridPane.setMargin(submitButton, new Insets(20.0, 0.0, 20.0, 0.0));
        Button goHomeButton = new Button("Go Back Home");
        goHomeButton.setPrefHeight(40.0);
        goHomeButton.setDefaultButton(true);
        goHomeButton.setPrefWidth(100.0);
        gridPane.add(goHomeButton, 0, ++n, 4, 1);
        GridPane.setHalignment(goHomeButton, HPos.LEFT);
        GridPane.setMargin(goHomeButton, new Insets(2.0, 0.0, 2.0, 0.0));
        Label manLabel = new Label("Manager Logged In:\n" + ssn_1 + "\n\nEmployee being edited:\n" + emp_ssn);
        GridPane.setHalignment(manLabel, HPos.LEFT);
        gridPane.add(manLabel, 0, ++n, 2, 1);
        goHomeButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.mainPage(gridPane_1, primaryStage, ssn_1);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
        submitButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                PrinterJob printerJob = PrinterJob.createPrinterJob();
                PrinterJob job = PrinterJob.createPrinterJob();
                if (printerJob != null && printerJob.showPrintDialog(gridPane.getScene().getWindow())) {
                    PageLayout pageLayout = printerJob.getPrinter().createPageLayout(Paper.A5, PageOrientation.PORTRAIT, 0.0, 0.0, 0.0, 0.0);
                    double prnW = pageLayout.getPrintableWidth();
                    double prnH = pageLayout.getPrintableHeight();
                    int pagesAcross = (int)Math.ceil(gridPane.getWidth() / prnW);
                    int pagesDown = (int)Math.ceil(gridPane.getHeight() / prnH);
                    boolean success = true;
                    int pgRow = 0;
                    while (pgRow < pagesDown) {
                        int pgCol = 0;
                        while (pgCol < pagesAcross) {
                            gridPane.setTranslateX(-(prnW * (double)pgCol));
                            gridPane.setTranslateY(-(prnH * (double)pgRow));
                            success = printerJob.printPage(pageLayout, gridPane);
                            ++pgCol;
                        }
                        ++pgRow;
                    }
                    if (success) {
                        printerJob.endJob();
                    }
                }
                GridPane gridPane_1 = MainAccess.createRegistrationFormPane();
                MainAccess.finalReport(gridPane_1, primaryStage, ssn_1, empssn);
                ScrollPane sp = new ScrollPane(gridPane_1);
                Scene scene = new Scene(sp, 800.0, 500.0);
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        });
    }

    private static double ParseDouble(String strNumber) {
        if (strNumber != null && strNumber.length() > 0) {
            try {
                return Double.parseDouble(strNumber);
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static void main(String[] args) {
        MainAccess.launch(args);
    }
}

