/*
 * Decompiled with CFR 0.152.
 */
package com.company_project;

import com.company_project.MainAccess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;

public class AuditLog {
    private static final String[][] audittypes = new String[][]{{"0", "UPDATE", "UpdateEmployee"}, {"1", "UPDATE", "UpdateEmployeeWorksOn"}, {"2", "UPDATE", "UpdateEmployeeDependents"}, {"3", "UPDATE", "UpdateCompanyTable"}, {"4", "CREATE", "CreateNewEmployee"}, {"5", "CREATE", "CreateNewWorksOn"}, {"6", "CREATE", "CreateNewDependents"}, {"7", "CREATE", "CreateCompanyTable"}, {"8", "DELETE", "DeleteEmployee"}, {"9", "DELETE", "DeleteWorksOn"}, {"10", "DELETE", "DeleteDependent"}, {"11", "DELETE", "DeleteCompanyTable"}, {"12", "LOGGED IN", "ManagerLogin"}, {"13", "LOGGED OUT", "ManagerLogout"}};

    public static String getAuditName(int event) {
        String name = "";
        int i = 0;
        while (i < audittypes.length) {
            if (Integer.parseInt(audittypes[i][0]) == event) {
                name = audittypes[i][2];
                break;
            }
            ++i;
        }
        return name;
    }

    public static String getAuditType(int event) {
        String name = "";
        int i = 0;
        while (i < audittypes.length) {
            if (Integer.parseInt(audittypes[i][0]) == event) {
                name = audittypes[i][1];
                break;
            }
            ++i;
        }
        return name;
    }

    public static String getCurrentTime() {
        Date currentUtcTime = Date.from(Instant.now());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        return sdf.format(currentUtcTime);
    }

    public static String getAuditUserName(int ssn) {
        Connection conn = MainAccess.LocalinitialSetup(1);
        String sql1 = "SELECT fname AS FIRSTNAME, lname AS LASTNAME \r\nFROM EMPLOYEE WHERE ssn = " + ssn;
        String fname = "ERROR";
        String lname = "ERROR";
        try {
            Statement st = conn.createStatement();
            ResultSet res = st.executeQuery(sql1);
            while (res.next()) {
                fname = res.getString("FIRSTNAME");
                lname = res.getString("LASTNAME");
            }
            res.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        return String.valueOf(fname) + " " + lname;
    }

    public static int getAuditID() {
        Connection conn = MainAccess.LocalinitialSetup(2);
        String sql1 = "SELECT MAX(AL_ID_NUMBER) AS NUM FROM AL_RECORDS";
        int idnumber = 0;
        boolean zeroflag = false;
        try {
            Statement st = conn.createStatement();
            ResultSet res = st.executeQuery(sql1);
            while (res.next()) {
                idnumber = res.getInt("NUM");
                zeroflag = true;
            }
            res.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        if (zeroflag) {
            return ++idnumber;
        }
        return 1;
    }

    public static void createAuditLog(int ssn, int mgssn, int event) {
        int idnumber = AuditLog.getAuditID();
        String eventname = AuditLog.getAuditName(event);
        String eventtype = AuditLog.getAuditType(event);
        if (eventtype.equalsIgnoreCase("LOGGED IN")) {
            eventtype = "LOGIN";
        } else if (eventtype.equalsIgnoreCase("LOGGED OUT")) {
            eventtype = "LOGOUT";
        }
        String time = AuditLog.getCurrentTime();
        int userid = mgssn;
        String username = AuditLog.getAuditUserName(mgssn);
        String payload = AuditLog.getAuditDescription(ssn, mgssn, event);
        AuditLog.insertAuditLog(idnumber, eventtype, eventname, time, userid, username, payload);
    }

    public static void insertAuditLog(int idnumber, String eventtype, String eventname, String time, int userid, String username, String payload) {
        Connection conn = MainAccess.LocalinitialSetup(2);
        String sql = "INSERT INTO AL_RECORDS VALUES (?, ?, ?, ?, ?, ?, ?)";
        try {
            Statement st = conn.createStatement();
            PreparedStatement pt = null;
            pt = conn.prepareStatement(sql);
            pt.setInt(1, idnumber);
            pt.setString(2, eventtype);
            pt.setString(3, eventname);
            pt.setString(4, time);
            pt.setInt(5, userid);
            pt.setString(6, username);
            pt.setString(7, payload);
            pt.executeUpdate();
            pt.close();
            st.close();
            conn.close();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public static String getAuditDescription(int ssn, int mgssn, int event) {
        String ustring = "Employee name, ssn, dob, address, sex, salary, superssn, and/or dept no for " + ssn + " have been " + AuditLog.getAuditType(event) + "D in COMPANY table by manager " + mgssn;
        String wstring = "Works On have been " + AuditLog.getAuditType(event) + "D for user " + ssn + " by manager " + mgssn;
        String dstring = "Dependents have been " + AuditLog.getAuditType(event) + "D for user " + ssn + " by manager " + mgssn;
        String tstring = "COMPANY table has been " + AuditLog.getAuditType(event) + " by manager " + mgssn;
        String lstring = "Manager " + mgssn + " has " + AuditLog.getAuditType(event);
        String description = "NO EVENT PASSED";
        if (event == 0 || event == 4 || event == 8) {
            description = ustring;
        } else if (event == 1 || event == 5 || event == 9) {
            description = wstring;
        } else if (event == 2 || event == 6 || event == 10) {
            description = dstring;
        } else if (event == 3 || event == 7 || event == 11) {
            description = tstring;
        } else if (event == 12 || event == 13) {
            description = lstring;
        }
        return description;
    }
}

